/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.game.model;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueResources;
import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.common.model.ColumnState;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.game.model.BalanceGameChallenge;
import edu.colorado.phet.balanceandtorque.game.model.ChallengeViewConfig;
import edu.colorado.phet.balanceandtorque.game.model.MassDistancePair;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IModelComponentType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MassDeductionChallenge
extends BalanceGameChallenge {
    private static final ChallengeViewConfig VIEW_CONFIG = new ChallengeViewConfig(BalanceAndTorqueResources.Strings.WHAT_IS_THE_MASS, true, false);

    public MassDeductionChallenge(final MassDistancePair massDistancePair, List<Mass> list, List<MassDistancePair> list2) {
        super(ColumnState.NONE);
        ArrayList<MassDistancePair> arrayList = new ArrayList<MassDistancePair>(){
            {
                this.add(massDistancePair);
            }
        };
        this.fixedMassDistancePairs.addAll(arrayList);
        this.movableMasses.addAll(list);
        this.balancedConfiguration.addAll(list2);
    }

    @Override
    public ChallengeViewConfig getChallengeViewConfig() {
        return VIEW_CONFIG;
    }

    @Override
    public IModelComponentType getModelComponentType() {
        return BalanceAndTorqueSimSharing.ModelComponentTypes.massDeductionChallenge;
    }

    @Override
    public String getCorrectAnswerString() {
        assert (this.fixedMassDistancePairs.size() == 1);
        return Double.toString(((MassDistancePair)this.fixedMassDistancePairs.get((int)0)).mass.getMass());
    }

    public static MassDeductionChallenge create(Mass mass, double d, Mass mass2) {
        MassDistancePair massDistancePair = new MassDistancePair(mass, d);
        ArrayList<Mass> arrayList = new ArrayList<Mass>();
        arrayList.add(mass2);
        ArrayList<MassDistancePair> arrayList2 = new ArrayList<MassDistancePair>();
        arrayList2.add(new MassDistancePair(mass2, -mass.getMass() * d / mass2.getMass()));
        return new MassDeductionChallenge(massDistancePair, arrayList, arrayList2);
    }
}

