/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.game.model;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueResources;
import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.common.model.ColumnState;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.game.model.BalanceGameChallenge;
import edu.colorado.phet.balanceandtorque.game.model.ChallengeViewConfig;
import edu.colorado.phet.balanceandtorque.game.model.MassDistancePair;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IModelComponentType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BalanceMassesChallenge
extends BalanceGameChallenge {
    private static final ChallengeViewConfig VIEW_CONFIG = new ChallengeViewConfig(BalanceAndTorqueResources.Strings.BALANCE_ME, false, false);

    public BalanceMassesChallenge(List<MassDistancePair> list, List<Mass> list2, List<MassDistancePair> list3) {
        super(ColumnState.SINGLE_COLUMN);
        this.fixedMassDistancePairs.addAll(list);
        this.movableMasses.addAll(list2);
        this.balancedConfiguration.addAll(list3);
        for (MassDistancePair massDistancePair : list3) {
            if (list2.contains(massDistancePair.mass)) continue;
            throw new IllegalArgumentException("One or more of the masses in the solution are not on the list of movable masses.");
        }
    }

    @Override
    public ChallengeViewConfig getChallengeViewConfig() {
        return VIEW_CONFIG;
    }

    @Override
    public IModelComponentType getModelComponentType() {
        return BalanceAndTorqueSimSharing.ModelComponentTypes.balanceMassesChallenge;
    }

    public static BalanceMassesChallenge create(Mass mass, double d, Mass mass2) {
        ArrayList<MassDistancePair> arrayList = new ArrayList<MassDistancePair>();
        MassDistancePair massDistancePair = new MassDistancePair(mass, d);
        arrayList.add(massDistancePair);
        ArrayList<Mass> arrayList2 = new ArrayList<Mass>();
        arrayList2.add(mass2);
        ArrayList<MassDistancePair> arrayList3 = new ArrayList<MassDistancePair>();
        arrayList3.add(new MassDistancePair(mass2, -massDistancePair.mass.getMass() * massDistancePair.distance / mass2.getMass()));
        return new BalanceMassesChallenge(arrayList, arrayList2, arrayList3);
    }

    public static BalanceMassesChallenge create(Mass mass, double d, Mass mass2, double d2, Mass mass3) {
        ArrayList<MassDistancePair> arrayList = new ArrayList<MassDistancePair>();
        MassDistancePair massDistancePair = new MassDistancePair(mass, -d);
        arrayList.add(massDistancePair);
        MassDistancePair massDistancePair2 = new MassDistancePair(mass2, -d2);
        arrayList.add(massDistancePair2);
        ArrayList<Mass> arrayList2 = new ArrayList<Mass>();
        arrayList2.add(mass3);
        ArrayList<MassDistancePair> arrayList3 = new ArrayList<MassDistancePair>();
        double d3 = massDistancePair.mass.getMass() * massDistancePair.distance + massDistancePair2.mass.getMass() * massDistancePair2.distance;
        MassDistancePair massDistancePair3 = new MassDistancePair(mass3, -d3 / mass3.getMass());
        assert (massDistancePair3.distance % 0.25 == 0.0);
        arrayList3.add(massDistancePair3);
        return new BalanceMassesChallenge(arrayList, arrayList2, arrayList3);
    }

    @Override
    public String getCorrectAnswerString() {
        assert (this.movableMasses.size() == 1);
        for (MassDistancePair massDistancePair : this.balancedConfiguration) {
            if (!(massDistancePair.distance > 0.0)) continue;
            return BalanceAndTorqueSimSharing.DISTANCE_VALUE_FORMATTER.format(massDistancePair.distance);
        }
        return "NoSolution";
    }
}

