/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.view;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueResources;
import edu.colorado.phet.balanceandtorque.common.model.ShapeMass;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.common.view.MassDragHandler;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;

public class ShapeMassNode
extends PNode {
    private final Mass mass;
    private final ModelViewTransform mvt;
    private final PhetPPath shapeNode;

    public ShapeMassNode(ShapeMass shapeMass, final ModelViewTransform modelViewTransform, Color color, PhetPCanvas phetPCanvas, BooleanProperty booleanProperty) {
        this.mass = shapeMass;
        this.mvt = modelViewTransform;
        final MassLabelNode massLabelNode = new MassLabelNode(shapeMass.getMass());
        this.addChild(massLabelNode);
        booleanProperty.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                massLabelNode.setVisible(bl);
            }
        });
        final PhetPPath phetPPath = new PhetPPath(new Color(0, 0, 0, 0));
        this.addChild(phetPPath);
        this.shapeNode = new PhetPPath(color, (Stroke)new BasicStroke(1.0f), (Paint)Color.BLACK);
        this.addChild(this.shapeNode);
        shapeMass.shapeProperty.addObserver(new VoidFunction1<Shape>(){

            @Override
            public void apply(Shape shape) {
                Shape shape2 = AffineTransform.getTranslateInstance(-modelViewTransform.modelToViewX(0.0), -modelViewTransform.modelToViewY(0.0)).createTransformedShape(modelViewTransform.modelToView(shape));
                ShapeMassNode.this.shapeNode.setPathTo(shape2);
                massLabelNode.setScale(1.0);
                massLabelNode.setScale(Math.min(((ShapeMassNode)ShapeMassNode.this).shapeNode.getFullBoundsReference().width * 0.9 / massLabelNode.getFullBoundsReference().width, 1.0));
                massLabelNode.setOffset(ShapeMassNode.this.shapeNode.getFullBoundsReference().getCenterX() - massLabelNode.getFullBoundsReference().width / 2.0, ShapeMassNode.this.shapeNode.getFullBoundsReference().getY() - massLabelNode.getFullBoundsReference().height - 3.0);
                PBounds pBounds = ShapeMassNode.this.shapeNode.getFullBounds();
                Rectangle2D.Double double_ = new Rectangle2D.Double(((RectangularShape)pBounds).getX() - 1.0, ((RectangularShape)pBounds).getY() - 1.0, ((RectangularShape)pBounds).getWidth() + 2.0, ((RectangularShape)pBounds).getHeight() + 2.0);
                phetPPath.setPathTo(double_);
                ShapeMassNode.this.updatePositionAndAngle();
            }
        });
        shapeMass.addRotationalAngleChangeObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                ShapeMassNode.this.updatePositionAndAngle();
            }
        });
        shapeMass.addPositionChangeObserver(new VoidFunction1<Point2D>(){

            @Override
            public void apply(Point2D point2D) {
                ShapeMassNode.this.updatePositionAndAngle();
            }
        });
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new MassDragHandler(shapeMass, this, phetPCanvas, modelViewTransform));
    }

    private void updatePositionAndAngle() {
        this.setRotation(0.0);
        this.setOffset(this.mvt.modelToView(this.mass.getPosition()));
        this.rotate(-this.mass.getRotationAngle());
    }

    private static class MassLabelNode
    extends PNode {
        private static final Font FONT = new PhetFont(14);
        private static final DecimalFormat FORMATTER = new DecimalFormat("##.#");

        private MassLabelNode(double d) {
            final PText pText = new PText(FORMATTER.format(d));
            pText.setFont(FONT);
            this.addChild(pText);
            this.addChild(new PText(BalanceAndTorqueResources.Strings.KG){
                {
                    super(string);
                    this.setFont(FONT);
                    this.setOffset(pText.getFullBoundsReference().getCenterX() - this.getFullBoundsReference().width / 2.0, pText.getFullBoundsReference().getMaxY() - 5.0);
                }
            });
        }
    }
}

