/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.view;

import edu.colorado.phet.balanceandtorque.balancelab.view.ImageMassNode;
import edu.colorado.phet.balanceandtorque.common.model.ShapeMass;
import edu.colorado.phet.balanceandtorque.common.model.masses.ImageMass;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.common.model.masses.MysteryMass;
import edu.colorado.phet.balanceandtorque.common.view.BrickStackNode;
import edu.colorado.phet.balanceandtorque.common.view.MysteryMassNode;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Shape;

public class MassNodeFactory {
    public static PNode createMassNode(Mass mass, BooleanProperty booleanProperty, ModelViewTransform modelViewTransform, PhetPCanvas phetPCanvas) {
        PNode pNode;
        if (mass instanceof ShapeMass) {
            pNode = new BrickStackNode((ShapeMass)mass, modelViewTransform, phetPCanvas, booleanProperty);
        } else if (mass instanceof MysteryMass) {
            pNode = new MysteryMassNode(modelViewTransform, (MysteryMass)mass, phetPCanvas, booleanProperty);
        } else if (mass instanceof ImageMass) {
            pNode = new ImageMassNode(modelViewTransform, (ImageMass)mass, phetPCanvas, booleanProperty);
        } else {
            System.out.println("Error: Unrecognized mass type sent to MassNodeFactory.");
            assert (false);
            pNode = new UnimplementedMassNode(mass, modelViewTransform);
        }
        return pNode;
    }

    private static class UnimplementedMassNode
    extends PNode {
        private UnimplementedMassNode(Mass mass, ModelViewTransform modelViewTransform) {
            PText pText = new PText("Unimplemented Mass"){
                {
                    this.setFont(new PhetFont(20, true));
                }
            };
            this.addChild(new PhetPPath((Shape)pText.getFullBoundsReference(), Color.PINK));
            this.addChild(pText);
            this.setOffset(modelViewTransform.modelToView(mass.getPosition()));
        }
    }
}

