/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.view;

import edu.colorado.phet.balanceandtorque.common.model.Plank;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class LevelIndicatorNode
extends PNode {
    public LevelIndicatorNode(ModelViewTransform modelViewTransform, final Plank plank) {
        Point2D point2D = modelViewTransform.modelToView(new Point2D.Double(plank.getPivotPoint().getX() - 2.25, plank.getPlankSurfaceCenter().getY()));
        Point2D point2D2 = modelViewTransform.modelToView(new Point2D.Double(plank.getPivotPoint().getX() + 2.25, plank.getPlankSurfaceCenter().getY()));
        GeneralPath generalPath = new DoubleGeneralPath(){
            {
                this.moveTo(0.0, 0.0);
                this.lineTo(-40.0, -15.0);
                this.lineTo(-30.0, 0.0);
                this.lineTo(-40.0, 15.0);
                this.closePath();
            }
        }.getGeneralPath();
        final PhetPPath phetPPath = new PhetPPath(generalPath, (Stroke)new BasicStroke(1.0f), (Paint)Color.BLACK);
        phetPPath.setOffset(point2D.getX() - 5.0, point2D.getY());
        this.addChild(phetPPath);
        Shape shape = AffineTransform.getScaleInstance(-1.0, 1.0).createTransformedShape(generalPath);
        final PhetPPath phetPPath2 = new PhetPPath(shape, (Stroke)new BasicStroke(1.0f), (Paint)Color.BLACK);
        phetPPath2.setOffset(point2D2.getX() + 5.0, point2D2.getY());
        this.addChild(phetPPath2);
        plank.addShapeObserver(new SimpleObserver(){

            public void update() {
                if (Math.abs(plank.getTiltAngle()) < 0.0031415926535897933) {
                    phetPPath.setPaint(new Color(173, 255, 47));
                    phetPPath2.setPaint(new Color(173, 255, 47));
                } else {
                    phetPPath.setPaint(Color.LIGHT_GRAY);
                    phetPPath2.setPaint(Color.LIGHT_GRAY);
                }
            }
        });
    }
}

