/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.model.masses;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueResources;
import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.common.model.masses.LabeledImageMass;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class MysteryMass
extends LabeledImageMass {
    private static final List<LabeledImageMass.LabeledImageMassConfig> MYSTERY_MASS_CONFIGURATIONS = new ArrayList<LabeledImageMass.LabeledImageMassConfig>(){
        {
            this.add(new LabeledImageMass.LabeledImageMassConfig(20.0, BalanceAndTorqueResources.Images.MYSTERY_OBJECT_01, 0.25, BalanceAndTorqueResources.Strings.MASS_LABEL_A, true));
            this.add(new LabeledImageMass.LabeledImageMassConfig(5.0, BalanceAndTorqueResources.Images.MYSTERY_OBJECT_02, 0.3, BalanceAndTorqueResources.Strings.MASS_LABEL_B, true));
            this.add(new LabeledImageMass.LabeledImageMassConfig(15.0, BalanceAndTorqueResources.Images.MYSTERY_OBJECT_03, 0.35, BalanceAndTorqueResources.Strings.MASS_LABEL_C, true));
            this.add(new LabeledImageMass.LabeledImageMassConfig(10.0, BalanceAndTorqueResources.Images.MYSTERY_OBJECT_04, 0.4, BalanceAndTorqueResources.Strings.MASS_LABEL_D, true));
            this.add(new LabeledImageMass.LabeledImageMassConfig(2.5, BalanceAndTorqueResources.Images.MYSTERY_OBJECT_05, 0.25, BalanceAndTorqueResources.Strings.MASS_LABEL_E, true));
            this.add(new LabeledImageMass.LabeledImageMassConfig(52.5, BalanceAndTorqueResources.Images.MYSTERY_OBJECT_06, 0.35, BalanceAndTorqueResources.Strings.MASS_LABEL_F, true));
            this.add(new LabeledImageMass.LabeledImageMassConfig(25.0, BalanceAndTorqueResources.Images.MYSTERY_OBJECT_07, 0.4, BalanceAndTorqueResources.Strings.MASS_LABEL_G, true));
            this.add(new LabeledImageMass.LabeledImageMassConfig(7.5, BalanceAndTorqueResources.Images.MYSTERY_OBJECT_08, 0.3, BalanceAndTorqueResources.Strings.MASS_LABEL_H, true));
        }
    };
    private static int[] instanceCounts = new int[MYSTERY_MASS_CONFIGURATIONS.size()];
    private int myMysteryMassID;

    public MysteryMass(int n) {
        this(n, new Point2D.Double(0.0, 0.0));
    }

    public MysteryMass(int n, Point2D point2D) {
        super(MysteryMass.createMysteryMassUserComponent(n), point2D, MYSTERY_MASS_CONFIGURATIONS.get(n));
        if (n >= 0 && n < instanceCounts.length) {
            int n2 = n;
            instanceCounts[n2] = instanceCounts[n2] + 1;
        }
        this.myMysteryMassID = n;
    }

    public Mass createCopy() {
        return new MysteryMass(this.myMysteryMassID, this.getPosition());
    }

    private static IUserComponent createMysteryMassUserComponent(int n) {
        if (n >= instanceCounts.length || n < 0) {
            return new UserComponent("mysteryObjectWithInvalidID");
        }
        return new UserComponentChain(BalanceAndTorqueSimSharing.UserComponents.mysteryMass, new UserComponent(MysteryMass.MYSTERY_MASS_CONFIGURATIONS.get((int)n).labelText), new UserComponent(instanceCounts[n]));
    }
}

