/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.model.masses;

import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageMass
extends Mass {
    protected final Property<BufferedImage> imageProperty;
    protected final Property<Double> heightProperty = new Property<Double>(0.0);
    private double expectedAnimationTime = 0.0;
    private double animationStartHeight;

    public ImageMass(IUserComponent iUserComponent, double d, BufferedImage bufferedImage, double d2, Point2D point2D, boolean bl) {
        super(iUserComponent, d, point2D, bl);
        this.heightProperty.set(d2);
        this.imageProperty = new Property<BufferedImage>(bufferedImage);
    }

    public double getHeight() {
        return this.heightProperty.get();
    }

    public void addImageChangeObserver(VoidFunction1<BufferedImage> voidFunction1) {
        this.imageProperty.addObserver(voidFunction1);
        voidFunction1.apply(this.imageProperty.get());
    }

    public void addHeightChangeObserver(VoidFunction1<Double> voidFunction1) {
        this.heightProperty.addObserver(voidFunction1);
    }

    @Override
    public Point2D getMiddlePoint() {
        return new Point2D.Double(this.getPosition().getX(), this.getPosition().getY() + this.heightProperty.get() / 2.0);
    }

    @Override
    public void initiateAnimation() {
        double d = Math.max(this.getPosition().distance(this.animationDestination) / 0.75, 3.0);
        this.expectedAnimationTime = this.getPosition().distance(this.animationDestination) / d;
        this.animationMotionVector.setComponents(d, 0.0);
        double d2 = Math.atan2(this.animationDestination.getY() - this.getPosition().getY(), this.animationDestination.getX() - this.getPosition().getX());
        this.animationMotionVector.rotate(d2);
        this.animatingProperty.set(true);
        this.animationStartHeight = this.heightProperty.get();
    }

    @Override
    public void stepInTime(double d) {
        if (((Boolean)this.animatingProperty.get()).booleanValue()) {
            if (this.getPosition().distance(this.animationDestination) < this.animationMotionVector.magnitude() * d) {
                this.setPosition(this.animationDestination);
                this.animatingProperty.set(false);
                this.animationScale = 1.0;
            } else {
                this.translate(this.animationMotionVector.times(d));
                this.animationScale = Math.max(this.animationScale - d / this.expectedAnimationTime * 0.5, 0.1);
                this.heightProperty.set(this.animationScale * this.animationStartHeight);
            }
        }
    }

    @Override
    public Mass createCopy() {
        ImageMass imageMass = new ImageMass(this.userComponent, this.getMass(), this.imageProperty.get(), this.getHeight(), this.getPosition(), this.isMystery());
        imageMass.setCenterOfMassXOffset(this.getCenterOfMassXOffset());
        return imageMass;
    }
}

