/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.model.masses;

import edu.colorado.phet.balanceandtorque.common.model.masses.ImageMass;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class HumanMass
extends ImageMass {
    private final BufferedImage standingImage;
    private final double standingHeight;
    private final BufferedImage sittingImage;
    private final double sittingHeight;
    private final double sittingCenterOfMassXOffset;

    public HumanMass(IUserComponent iUserComponent, double d, BufferedImage bufferedImage, double d2, BufferedImage bufferedImage2, double d3, Point2D point2D, double d4, boolean bl) {
        super(iUserComponent, d, bufferedImage, d2, point2D, bl);
        this.standingImage = bufferedImage;
        this.standingHeight = d2;
        this.sittingImage = bufferedImage2;
        this.sittingHeight = d3;
        this.sittingCenterOfMassXOffset = d4;
    }

    public void setOnPlank(boolean bl) {
        if (bl) {
            this.heightProperty.set(this.sittingHeight);
            if (this.getPosition().getX() > 0.0) {
                this.imageProperty.set(this.sittingImage);
                this.setCenterOfMassXOffset(this.sittingCenterOfMassXOffset);
            } else {
                this.imageProperty.set(BufferedImageUtils.flipX(this.sittingImage));
                this.setCenterOfMassXOffset(-this.sittingCenterOfMassXOffset);
            }
        } else {
            this.heightProperty.set(this.standingHeight);
            this.imageProperty.set(this.standingImage);
            this.setCenterOfMassXOffset(0.0);
        }
    }
}

