/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.common.model;

import edu.colorado.phet.balanceandtorque.common.model.Plank;
import edu.colorado.phet.balanceandtorque.common.model.ShapeModelElement;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class AttachmentBar
extends ShapeModelElement {
    private final Plank plank;

    public AttachmentBar(final Plank plank) {
        super(AttachmentBar.generateShape(plank.getPivotPoint(), plank.bottomCenterPoint.get()));
        this.plank = plank;
        plank.bottomCenterPoint.addObserver(new VoidFunction1<Point2D>(){

            @Override
            public void apply(Point2D point2D) {
                AttachmentBar.this.setShape(AttachmentBar.generateShape(plank.getPivotPoint(), plank.bottomCenterPoint.get()));
            }
        });
    }

    public Point2D getPivotPoint() {
        return this.plank.getPivotPoint();
    }

    public double getDeflectionAngle() {
        return this.plank.getTiltAngle();
    }

    private static Shape generateShape(Point2D point2D, Point2D point2D2) {
        double d = point2D.distance(point2D2);
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(0.0, 0.0);
        doubleGeneralPath.lineTo(0.025, 0.0);
        doubleGeneralPath.lineTo(0.025, d);
        doubleGeneralPath.lineTo(-0.025, d);
        doubleGeneralPath.lineTo(-0.025, 0.0);
        doubleGeneralPath.closePath();
        Shape shape = AffineTransform.getRotateInstance(Math.atan2(point2D2.getY() - point2D.getY(), point2D2.getX() - point2D.getX()) - 1.5707963267948966).createTransformedShape(doubleGeneralPath.getGeneralPath());
        shape = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY()).createTransformedShape(shape);
        return shape;
    }
}

