/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.balancelab.view;

import edu.colorado.phet.balanceandtorque.common.model.AttachmentBar;
import edu.colorado.phet.balanceandtorque.common.view.ModelObjectNode;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class AttachmentBarNode
extends ModelObjectNode {
    private static final Color BASE_COLOR = Color.LIGHT_GRAY;

    public AttachmentBarNode(final ModelViewTransform modelViewTransform, final AttachmentBar attachmentBar) {
        super(modelViewTransform, attachmentBar, AttachmentBarNode.createGradientPaint(modelViewTransform, attachmentBar));
        double d = modelViewTransform.modelToViewDeltaX(0.1);
        PhetPPath phetPPath = new PhetPPath(new Ellipse2D.Double(-d / 2.0, -d / 2.0, d, d), BASE_COLOR, new BasicStroke(1.0f), Color.BLACK);
        phetPPath.setOffset(modelViewTransform.modelToView(attachmentBar.getPivotPoint()));
        phetPPath.addChild(new PhetPPath((Shape)new Ellipse2D.Double(-d / 10.0, -d / 10.0, d / 5.0, d / 5.0), Color.BLACK));
        this.addChild(phetPPath);
        attachmentBar.addShapeObserver(new VoidFunction1<Shape>(){

            @Override
            public void apply(Shape shape) {
                AttachmentBarNode.this.setPaint(AttachmentBarNode.createGradientPaint(modelViewTransform, attachmentBar));
            }
        });
    }

    private static Paint createGradientPaint(ModelViewTransform modelViewTransform, AttachmentBar attachmentBar) {
        MutableVector2D mutableVector2D = new MutableVector2D(0.025, 0.0).rotate(attachmentBar.getDeflectionAngle());
        MutableVector2D mutableVector2D2 = new MutableVector2D(attachmentBar.getPivotPoint());
        return new GradientPaint(modelViewTransform.modelToView(new MutableVector2D(mutableVector2D2).subtract(mutableVector2D).toPoint2D()), ColorUtils.brighterColor(BASE_COLOR, 0.5), modelViewTransform.modelToView(new MutableVector2D(mutableVector2D2).add(mutableVector2D).toPoint2D()), ColorUtils.darkerColor(BASE_COLOR, 0.5));
    }
}

