/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.balancelab.model;

import edu.colorado.phet.balanceandtorque.common.model.BalanceModel;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import java.util.ArrayList;

public class BalanceLabModel
extends BalanceModel {
    public BalanceLabModel() {
        this.clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                BalanceLabModel.this.stepInTime(BalanceLabModel.this.clock.getDt());
            }
        });
    }

    public void addMass(final Mass mass) {
        super.addMass(mass);
        mass.userControlled.addObserver(new ChangeObserver<Boolean>(){

            @Override
            public void update(Boolean bl, Boolean bl2) {
                if (!bl.booleanValue() && bl2.booleanValue() && !BalanceLabModel.this.plank.addMassToSurface(mass)) {
                    BalanceLabModel.this.removeMassAnimated(mass);
                }
            }
        });
    }

    public void reset() {
        super.reset();
        for (Mass mass : new ArrayList(this.massList)) {
            this.removeMass(mass);
        }
    }

    protected void removeMassAnimated(final Mass mass) {
        mass.addAnimationStateObserver(new ChangeObserver<Boolean>(){

            @Override
            public void update(Boolean bl, Boolean bl2) {
                if (bl2.booleanValue() && !bl.booleanValue()) {
                    mass.removeAnimationStateObserver(this);
                    BalanceLabModel.this.massList.remove(mass);
                }
            }
        });
        mass.initiateAnimation();
    }
}

